#!/usr/bin/perl
###############################################################################
#	REPORT2.CGI				BY JONATHAN ALMAREZ					08/24/2000
#
#	DESCRIPTION:
#		This script is apart of the Banner Manager system.  It generates reports 
#		avaliable by compiling the data from the log files.  
#
###############################################################################

require 'cgi-lib1.pl';
require 'addbanner.cgi';

&ReadParse(*input);

($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$day_lite_savings) = localtime(time);
$year = ($year - 100) + 2000;
$mon++;
$logfile = "$mon-$mday-$year.log";

%smonths = ("1","Jan","2","Feb","3","Mar","4","Apr","5","May","6","Jun","7","Jul","8","Aug","9","Sep","10","Oct","11","Nov","12","Dec");

open(HEADERFILE, "titles.dat") || die("error opening the file titles.dat");
	@title_lines = <HEADERFILE>;
close(HEADERFILE);
for ($n=0;$n<=$#title_lines;$n++) {
	($title,$banner) = split(/\|\|/,$title_lines[$n]);
	chomp($banner);
	$title =~ tr/A-Z/a-z/;
	$title_list{$banner} = $title;
	push(@all_titles, $title);
	if ($title eq $input{'title'}) {$theban = $banner;}
}

@all_titles = sort (@all_titles);

#-------------------------------------------------------------------#
if ($input{'action'} eq 'fullmonthreport') {
#-------------------------------------------------------------------#
print "Content-type: text/html\n\n";
$link = "$jump_script/report2.cgi?action=fullmonthreport2&month=$input{'month'}";
$link =~ s/ /\+/g;
print "<HTML><HEAD><meta http-equiv=\"refresh\" content=\"0;url=$link\"></HEAD><BODY BGCOLOR=\"#FFFFFF\"><CENTER><FONT SIZE=\"5\" COLOR=\"#FF3366\">Processing your request, please wait...</FONT></CENTER></body></HTML>";
#-------------------------------------------------------------------#
}elsif ($input{'action'} eq 'catmonthreport') {
#-------------------------------------------------------------------#
print "Content-type: text/html\n\n";
$link = "$jump_script/report2.cgi?action=catmonthreport2&cat=$input{'cat'}&month=$input{'month'}";
$link =~ s/ /\+/g;
print "<HTML><HEAD><meta http-equiv=\"refresh\" content=\"0;url=$link\"></HEAD><BODY BGCOLOR=\"#FFFFFF\"><CENTER><FONT SIZE=\"5\" COLOR=\"#FF3366\">Processing your request, please wait...</FONT></CENTER></body></HTML>";
#-------------------------------------------------------------------#
}elsif ($input{'action'} eq 'banmonthreport') {
#-------------------------------------------------------------------#
print "Content-type: text/html\n\n";
$link = "$jump_script/report2.cgi?action=banmonthreport2&title=$input{'title'}&month=$input{'month'}";
$link =~ s/ /\+/g;
print "<HTML><HEAD><meta http-equiv=\"refresh\" content=\"0;url=$link\"></HEAD><BODY BGCOLOR=\"#FFFFFF\"><CENTER><FONT SIZE=\"5\" COLOR=\"#FF3366\">Processing your request, please wait...</FONT></CENTER></body></HTML>";
#-------------------------------------------------------------------#
}elsif ($input{'action'} eq 'banmonthreport2') {
#-------------------------------------------------------------------#
opendir(LOGDIR, ".") || die("error");
	@file_list = readdir(LOGDIR);
closedir(LOGDIR);

($namemonth) = split(/ /,$input{'month'});

foreach $file (@file_list) {
	($name,$exe) = split(/\./,$file);
	if ($exe eq 'log') {
		($month,$day,$year) = split(/\-/,$name);
		if ($smonths{$month} eq $namemonth) {
			push(@log_filenames, $name);
			$all_days{"$name"} = 'x';
		}
	}
}

foreach $file (@log_filenames) {
	open(HEADERFILE, "$file.log") || die("error opening the file $file.log");
		@the_log_lines = <HEADERFILE>;
	close(HEADERFILE);
	push(@log_lines, @the_log_lines);
}

foreach $line (@log_lines) {
	($mark,$banner,$cat,$timestamp) = split(/\|\|/,$line);
	chomp($timestamp);
	if ($banner) {
		push(@marks, $mark);
		push(@banners, $banner);
		push(@cats, $cat);
		push(@timestamps, $timestamp);
		($hour,$min) = split(/\:/,$timestamp);

		if ($mark eq 'C') {
			if ($banner eq $theban) {
				$banners_click_list{$banner} = $banners_click_list{$banner} + 1;
				$category_click_list{$cat} = $category_click_list{$cat} + 1;
				$timeline_click_list{$hour}++;
			}
		}else{
			if ($banner eq $theban) {
				$banners_imp_list{$banner} = $banners_imp_list{$banner} + 1;
				$category_imp_list{$cat} = $category_imp_list{$cat} + 1;
				$timeline_imp_list{$hour}++;
			}
		}
	}
}

for ($n=0;$n<=$#marks;$n++) {
	if ($marks[$n] eq 'C') {
		$total_clicks++;
	}else{
		$total_impressions++;
	}
}

if ($total_clicks >= $total_impressions) {
	$total_total = $total_clicks;
}else{
	$total_total = $total_impressions;
}

if ($total_clicks) {
	$total_clicks_per = ($total_clicks / $total_total) * 100;
}else{
	$total_clicks_per = 0;
}
if ($total_impressions) {
	$total_imp_per = ($total_impressions / $total_total) * 100;
}else{
	$total_imp_per = 0;
}

while (($key,$value) = each(%banners_click_list)) {
	if ($value > $max_banner_clicks) {$max_banner_clicks = $value;}
}

while (($key,$value) = each(%banners_imp_list)) {
	if ($value > $max_banner_imps) {$max_banner_imps = $value;}
}

while (($key,$value) = each(%category_click_list)) {
	if ($value > $max_cat_clicks) {$max_cat_clicks = $value;}
}

while (($key,$value) = each(%category_imp_list)) {
	if ($value > $max_cat_imps) {$max_cat_imps = $value;}
}

while (($key,$value) = each(%timeline_click_list)) {
	if ($value > $max_time_clicks) {$max_time_clicks = $value;}
}

while (($key,$value) = each(%timeline_imp_list)) {
	if ($value > $max_time_imps) {$max_time_imps = $value;}
}

print "Content-type: text/html\n\n";
print <<EOF;
<html>
<BODY BGCOLOR="#FFFFFF">
<FONT SIZE="7" COLOR="#000099" face="Arial,Helvetica">Month Banner Report</FONT>
<br>
<FONT SIZE="4" COLOR="#000099" face="Arial,Helvetica">$input{'title'} on $input{'month'}</FONT>
<HR size=1><p>
<H3>Clicks by banner</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%banners_click_list)) {
if ($max_banner_clicks) {$banner_click_per = ($value / $max_banner_clicks) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$title_list{$key}</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$banner_click_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Impressions by banner</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%banners_imp_list)) {
if ($max_banner_imps) {$banner_imp_per = ($value / $max_banner_imps) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$title_list{$key}</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$banner_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Clicks by category</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%category_click_list)) {
if ($max_cat_clicks) {$category_cat_per = ($value / $max_cat_clicks) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$key</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$category_cat_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Impressions by category</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%category_imp_list)) {
if ($max_cat_imps) {$category_imp_per = ($value / $max_cat_imps) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$key</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$category_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Timeline by clicks</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
for ($n=1;$n<=24;$n++) {
if ($n =~ /\d\d/) {$t = $n}else{$t = ("0$n")}
if ($max_time_clicks) {$timeline_click_per = ($timeline_click_list{$t} / $max_time_clicks) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$t</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$timeline_click_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$timeline_click_list{$t}</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Timeline by impressions</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
for ($n=1;$n<=24;$n++) {
if ($n =~ /\d\d/) {$t = $n}else{$t = ("0$n")}
if ($max_time_imps) {$timeline_imp_per = ($timeline_imp_list{$t} / $max_time_imps) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$t</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$timeline_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$timeline_imp_list{$t}</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
EOF

#-------------------------------------------------------------------#
}elsif ($input{'action'} eq 'catmonthreport2') {
#-------------------------------------------------------------------#

opendir(LOGDIR, ".") || die("error");
	@file_list = readdir(LOGDIR);
closedir(LOGDIR);

($namemonth) = split(/ /,$input{'month'});

foreach $file (@file_list) {
	($name,$exe) = split(/\./,$file);
	if ($exe eq 'log') {
		($month,$day,$year) = split(/\-/,$name);
		if ($smonths{$month} eq $namemonth) {
			push(@log_filenames, $name);
			$all_days{"$name"} = 'x';
		}
	}
}

foreach $file (@log_filenames) {
	open(HEADERFILE, "$file.log") || die("error opening the file $file.log");
		@the_log_lines = <HEADERFILE>;
	close(HEADERFILE);
	push(@log_lines, @the_log_lines);
}
foreach $line (@log_lines) {
	($mark,$banner,$cat,$timestamp) = split(/\|\|/,$line);
	chomp($timestamp);
	if ($banner) {
		push(@marks, $mark);
		push(@banners, $banner);
		push(@cats, $cat);
		push(@timestamps, $timestamp);
		($hour,$min) = split(/\:/,$timestamp);

		if ($mark eq 'C') {
			if ($cat eq $input{'cat'}) {
				$banners_click_list{$banner} = $banners_click_list{$banner} + 1;
				$category_click_list{$cat} = $category_click_list{$cat} + 1;
				$timeline_click_list{$hour}++;
			}
		}else{
			if ($cat eq $input{'cat'}) {
				$banners_imp_list{$banner} = $banners_imp_list{$banner} + 1;
				$category_imp_list{$cat} = $category_imp_list{$cat} + 1;
				$timeline_imp_list{$hour}++;
			}
		}
	}
}

for ($n=0;$n<=$#marks;$n++) {
	if ($marks[$n] eq 'C') {
		$total_clicks++;
	}else{
		$total_impressions++;
	}
}

if ($total_clicks >= $total_impressions) {
	$total_total = $total_clicks;
}else{
	$total_total = $total_impressions;
}

if ($total_clicks) {
	$total_clicks_per = ($total_clicks / $total_total) * 100;
}else{
	$total_clicks_per = 0;
}
if ($total_impressions) {
	$total_imp_per = ($total_impressions / $total_total) * 100;
}else{
	$total_imp_per = 0;
}

while (($key,$value) = each(%banners_click_list)) {
	if ($value > $max_banner_clicks) {$max_banner_clicks = $value;}
}

while (($key,$value) = each(%banners_imp_list)) {
	if ($value > $max_banner_imps) {$max_banner_imps = $value;}
}

while (($key,$value) = each(%category_click_list)) {
	if ($value > $max_cat_clicks) {$max_cat_clicks = $value;}
}

while (($key,$value) = each(%category_imp_list)) {
	if ($value > $max_cat_imps) {$max_cat_imps = $value;}
}

while (($key,$value) = each(%timeline_click_list)) {
	if ($value > $max_time_clicks) {$max_time_clicks = $value;}
}

while (($key,$value) = each(%timeline_imp_list)) {
	if ($value > $max_time_imps) {$max_time_imps = $value;}
}

print "Content-type: text/html\n\n";
print <<EOF;
<html>
<BODY BGCOLOR="#FFFFFF">
<FONT SIZE="7" COLOR="#000099" face="Arial,Helvetica">Month Category Report</FONT>
<br>
<FONT SIZE="4" COLOR="#000099" face="Arial,Helvetica">$input{'cat'} on $input{'month'}</FONT>
<HR size=1><p>
<H3>Clicks by banner</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%banners_click_list)) {
if ($max_banner_clicks) {$banner_click_per = ($value / $max_banner_clicks) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$title_list{$key}</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$banner_click_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Impressions by banner</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%banners_imp_list)) {
if ($max_banner_imps) {$banner_imp_per = ($value / $max_banner_imps) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$title_list{$key}</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$banner_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Clicks by category</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%category_click_list)) {
if ($max_cat_clicks) {$category_cat_per = ($value / $max_cat_clicks) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$key</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$category_cat_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Impressions by category</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%category_imp_list)) {
if ($max_cat_imps) {$category_imp_per = ($value / $max_cat_imps) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$key</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$category_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Timeline by clicks</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
for ($n=1;$n<=24;$n++) {
if ($n =~ /\d\d/) {$t = $n}else{$t = ("0$n")}
if ($max_time_clicks) {$timeline_click_per = ($timeline_click_list{$t} / $max_time_clicks) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$t</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$timeline_click_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$timeline_click_list{$t}</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Timeline by impressions</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
for ($n=1;$n<=24;$n++) {
if ($n =~ /\d\d/) {$t = $n}else{$t = ("0$n")}
if ($max_time_imps) {$timeline_imp_per = ($timeline_imp_list{$t} / $max_time_imps) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$t</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$timeline_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$timeline_imp_list{$t}</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
EOF

#-------------------------------------------------------------------#
}elsif ($input{'action'} eq 'fullmonthreport2') {
#-------------------------------------------------------------------#

opendir(LOGDIR, ".") || die("error");
	@file_list = readdir(LOGDIR);
closedir(LOGDIR);

($namemonth) = split(/ /,$input{'month'});

foreach $file (@file_list) {
	($name,$exe) = split(/\./,$file);
	if ($exe eq 'log') {
		($month,$day,$year) = split(/\-/,$name);
		if ($smonths{$month} eq $namemonth) {
			push(@log_filenames, $name);
			$all_days{"$name"} = 'x';
		}
	}
}

foreach $file (@log_filenames) {
	open(HEADERFILE, "$file.log") || die("error opening the file $file.log");
		@the_log_lines = <HEADERFILE>;
	close(HEADERFILE);
	push(@log_lines, @the_log_lines);
}

foreach $line (@log_lines) {
	($mark,$banner,$cat,$timestamp) = split(/\|\|/,$line);
	chomp($timestamp);
	if ($banner) {
		push(@marks, $mark);
		push(@banners, $banner);
		push(@cats, $cat);
		push(@timestamps, $timestamp);
		($hour,$min) = split(/\:/,$timestamp);

		if ($mark eq 'C') {
				$banners_click_list{$banner} = $banners_click_list{$banner} + 1;
				$category_click_list{$cat} = $category_click_list{$cat} + 1;
				$timeline_click_list{$hour}++;
		}else{
				$banners_imp_list{$banner} = $banners_imp_list{$banner} + 1;
				$category_imp_list{$cat} = $category_imp_list{$cat} + 1;
				$timeline_imp_list{$hour}++;
		}
	}
}

for ($n=0;$n<=$#marks;$n++) {
	if ($marks[$n] eq 'C') {
		$total_clicks++;
	}else{
		$total_impressions++;
	}
}


if ($total_clicks >= $total_impressions) {
	$total_total = $total_clicks;
}else{
	$total_total = $total_impressions;
}
$total_clicks_per = ($total_clicks / $total_total) * 100;
$total_imp_per = ($total_impressions / $total_total) * 100;

while (($key,$value) = each(%banners_click_list)) {
	if ($value > $max_banner_clicks) {$max_banner_clicks = $value;}
}

while (($key,$value) = each(%banners_imp_list)) {
	if ($value > $max_banner_imps) {$max_banner_imps = $value;}
}

while (($key,$value) = each(%category_click_list)) {
	if ($value > $max_cat_clicks) {$max_cat_clicks = $value;}
}

while (($key,$value) = each(%category_imp_list)) {
	if ($value > $max_cat_imps) {$max_cat_imps = $value;}
}

while (($key,$value) = each(%timeline_click_list)) {
	if ($value > $max_time_clicks) {$max_time_clicks = $value;}
}

while (($key,$value) = each(%timeline_imp_list)) {
	if ($value > $max_time_imps) {$max_time_imps = $value;}
}

print "Content-type: text/html\n\n";
print <<EOF;
<html>
<BODY BGCOLOR="#FFFFFF">
<FONT SIZE="7" COLOR="#000099" face="Arial,Helvetica">Month Report</FONT>
<br>
<FONT SIZE="4" COLOR="#000099" face="Arial,Helvetica">On $input{'month'}</FONT>
<HR size=1><p>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
<TR>
	<TD><FONT SIZE="2" face="Arial,Helvetica"><B>Total Clicks:</B></FONT></TD>
	<TD width="75%" bgcolor="#EEEEEE"><Table width="$total_clicks_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$total_clicks</FONT></td></tr></table></TD>
</TR>
<TR>
	<TD><FONT SIZE="2" face="Arial,Helvetica"><B>Total Impressions:</B></FONT></TD>
	<TD width="75%" bgcolor="#EEEEEE"><Table width="$total_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$total_impressions</FONT></td></tr></table></TD>
</TR>

</TABLE>

<H3>Clicks by banner</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%banners_click_list)) {
$banner_click_per = ($value / $max_banner_clicks) * 100;
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$title_list{$key}</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$banner_click_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Impressions by banner</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%banners_imp_list)) {
$banner_imp_per = ($value / $max_banner_imps) * 100;
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$title_list{$key}</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$banner_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Clicks by category</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%category_click_list)) {
$category_cat_per = ($value / $max_cat_clicks) * 100;
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$key</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$category_cat_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Impressions by category</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%category_imp_list)) {
$category_imp_per = ($value / $max_cat_imps) * 100;
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$key</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$category_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Timeline by clicks</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
for ($n=1;$n<=24;$n++) {
if ($n =~ /\d\d/) {$t = $n}else{$t = ("0$n")}
$timeline_click_per = ($timeline_click_list{$t} / $max_time_clicks) * 100;
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$t</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$timeline_click_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$timeline_click_list{$t}</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Timeline by impressions</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
for ($n=1;$n<=24;$n++) {
if ($n =~ /\d\d/) {$t = $n}else{$t = ("0$n")}
$timeline_imp_per = ($timeline_imp_list{$t} / $max_time_imps) * 100;
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$t</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$timeline_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$timeline_imp_list{$t}</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
EOF
#-------------------------------------------------------------------#
}elsif ($input{'action'} eq 'dayreport') {
#-------------------------------------------------------------------#
open(HEADERFILE, "categories.dat") || die("error opening the file categories.dat");
	@cat_lines = <HEADERFILE>;
close(HEADERFILE);

@all_categories = @cat_lines;

$totalcat = $#all_categories+1;
print "Content-type: text/html\n\n";
print <<EOF;
<html>
<BODY BGCOLOR="#FFFFFF">
<FONT SIZE="7" COLOR="#000099" face="Arial,Helvetica">Banner Statistics</FONT>
<br>
<FONT SIZE="1" COLOR="#000099" face="Arial,Helvetica"><A HREF="report2.cgi">Home</A> | <A HREF="bannereditor.cgi">Banner Manager</A></FONT>
<HR size=1><p>

<TABLE width="75%" cellpadding=0 cellspacing=2 border=0>
<TR>
	<TD><FONT SIZE="5" COLOR="#003399" face="Arial,Helvetica">$input{'day'}</FONT></TD>
	<TD><FONT SIZE="5" COLOR="#003399" face="Arial,Helvetica"></FONT></TD>
</TR>
<TR>
	<TD><FONT SIZE="2" COLOR="#003399" face="Arial,Helvetica">
		<A HREF="report2.cgi?action=fullreport&log=$input{'day'}.log">Full Report</A><br>
		<p>($totalcat) By Category:<br><UL>
EOF
foreach $cat (@all_categories) {
			print "<LI><A HREF=\"report2.cgi?action=catreport&log=$input{'day'}.log&cat=$cat\">$cat</A>";
}
$totaltitles = $#all_titles +1;
print <<EOF;
		</UL><p>
		($totaltitles) By Banner:<br>
		<UL>
EOF
foreach $title (@all_titles) {
		$tmp = $title;
		$tmp =~ s/ /\+/g;
		print "<LI><A HREF=\"report2.cgi?action=banreport&log=$input{'day'}.log&title=$tmp\">$title</A>";
}
print <<EOF;
		</UL>
	</FONT></TD>
	<TD valign="top" ><FONT SIZE="3" COLOR="#003399" face="Arial,Helvetica">
	</FONT></TD>
</TR>

</TABLE></CENTER>
EOF
#-------------------------------------------------------------------#
}elsif ($input{'action'} eq 'monthreport') {
#-------------------------------------------------------------------#
opendir(LOGDIR, ".") || die("error");
	@file_list = readdir(LOGDIR);
closedir(LOGDIR);

($namemonth) = split(/ /,$input{'month'});

foreach $file (@file_list) {
	($name,$exe) = split(/\./,$file);
	if ($exe eq 'log') {
		($month,$day,$year) = split(/\-/,$name);
		if ($smonths{$month} eq $namemonth) {
			push(@log_filenames, $name);
			$all_days{"$name"} = 'x';
		}
	}
}

open(HEADERFILE, "categories.dat") || die("error opening the file categories.dat");
		@cat_lines = <HEADERFILE>;
close(HEADERFILE);

@all_categories = @cat_lines;
$totalcat = $#all_categories+1;
print "Content-type: text/html\n\n";
print <<EOF;
<html>
<BODY BGCOLOR="#FFFFFF">
<FONT SIZE="7" COLOR="#000099" face="Arial,Helvetica">Banner Statistics</FONT>
<br>
<FONT SIZE="1" COLOR="#000099" face="Arial,Helvetica"><A HREF="report2.cgi">Home</A> | <A HREF="bannereditor.cgi">Banner Manager</A></FONT>
<HR size=1><p>

<TABLE width="75%" cellpadding=0 cellspacing=2 border=0>
<TR>
	<TD><FONT SIZE="5" COLOR="#003399" face="Arial,Helvetica">$input{'month'}</FONT></TD>
	<TD><FONT SIZE="5" COLOR="#003399" face="Arial,Helvetica">Days</FONT></TD>
</TR>
<TR>
	<TD><FONT SIZE="2" COLOR="#003399" face="Arial,Helvetica">
		<A HREF="report2.cgi?action=fullmonthreport&month=$input{'month'}">Full Report</A><br>
		<p>($totalcat) By Category:<br><UL>
EOF
foreach $cat (@all_categories) {
			print "<LI><A HREF=\"report2.cgi?action=catmonthreport&month=$input{'month'}&cat=$cat\">$cat</A>";
}
$totaltitles = $#all_titles +1;
print <<EOF;
		</UL><p>
		($totaltitles) By Banner:<br>
		<UL>
EOF
foreach $title (@all_titles) {
		$tmp = $title;
		$tmp =~ s/ /\+/g;
		print "<LI><A HREF=\"report2.cgi?action=banmonthreport&month=$input{'month'}&title=$tmp\">$title</A>";
}
print <<EOF;
		</UL>
	</FONT></TD>
	<TD valign="top" ><FONT SIZE="3" COLOR="#003399" face="Arial,Helvetica">
EOF
foreach $day (keys(%all_days)) {
	print "<A HREF=\"report2.cgi?action=dayreport&day=$day\">$day</A><br>";
}
print <<EOF;
	</FONT></TD>
</TR>

</TABLE></CENTER>
EOF
#-------------------------------------------------------------------#
}elsif ($input{'action'} eq 'banreport') {
#-------------------------------------------------------------------#

open(HEADERFILE, "$input{'log'}") || die("error opening the file $input{'log'}");
	@log_lines = <HEADERFILE>;
close(HEADERFILE);

foreach $line (@log_lines) {
	($mark,$banner,$cat,$timestamp) = split(/\|\|/,$line);
	chomp($timestamp);
	if ($banner) {
		push(@marks, $mark);
		push(@banners, $banner);
		push(@cats, $cat);
		push(@timestamps, $timestamp);
		($hour,$min) = split(/\:/,$timestamp);

		if ($mark eq 'C') {
			if ($banner eq $theban) {
				$banners_click_list{$banner} = $banners_click_list{$banner} + 1;
				$category_click_list{$cat} = $category_click_list{$cat} + 1;
				$timeline_click_list{$hour}++;
			}
		}else{
			if ($banner eq $theban) {
				$banners_imp_list{$banner} = $banners_imp_list{$banner} + 1;
				$category_imp_list{$cat} = $category_imp_list{$cat} + 1;
				$timeline_imp_list{$hour}++;
			}
		}
	}
}

for ($n=0;$n<=$#marks;$n++) {
	if ($marks[$n] eq 'C') {
		$total_clicks++;
	}else{
		$total_impressions++;
	}
}

if ($total_clicks >= $total_impressions) {
	$total_total = $total_clicks;
}else{
	$total_total = $total_impressions;
}

if ($total_clicks) {
	$total_clicks_per = ($total_clicks / $total_total) * 100;
}else{
	$total_clicks_per = 0;
}
if ($total_impressions) {
	$total_imp_per = ($total_impressions / $total_total) * 100;
}else{
	$total_imp_per = 0;
}

while (($key,$value) = each(%banners_click_list)) {
	if ($value > $max_banner_clicks) {$max_banner_clicks = $value;}
}

while (($key,$value) = each(%banners_imp_list)) {
	if ($value > $max_banner_imps) {$max_banner_imps = $value;}
}

while (($key,$value) = each(%category_click_list)) {
	if ($value > $max_cat_clicks) {$max_cat_clicks = $value;}
}

while (($key,$value) = each(%category_imp_list)) {
	if ($value > $max_cat_imps) {$max_cat_imps = $value;}
}

while (($key,$value) = each(%timeline_click_list)) {
	if ($value > $max_time_clicks) {$max_time_clicks = $value;}
}

while (($key,$value) = each(%timeline_imp_list)) {
	if ($value > $max_time_imps) {$max_time_imps = $value;}
}

print "Content-type: text/html\n\n";
print <<EOF;
<html>
<BODY BGCOLOR="#FFFFFF">
<FONT SIZE="7" COLOR="#000099" face="Arial,Helvetica">Banner Report</FONT>
<br>
<FONT SIZE="4" COLOR="#000099" face="Arial,Helvetica">$input{'title'} on log $input{'log'}</FONT>
<HR size=1><p>
<H3>Clicks by banner</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%banners_click_list)) {
if ($max_banner_clicks) {$banner_click_per = ($value / $max_banner_clicks) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$title_list{$key}</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$banner_click_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Impressions by banner</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%banners_imp_list)) {
if ($max_banner_imps) {$banner_imp_per = ($value / $max_banner_imps) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$title_list{$key}</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$banner_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Clicks by category</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%category_click_list)) {
if ($max_cat_clicks) {$category_cat_per = ($value / $max_cat_clicks) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$key</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$category_cat_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Impressions by category</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%category_imp_list)) {
if ($max_cat_imps) {$category_imp_per = ($value / $max_cat_imps) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$key</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$category_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Timeline by clicks</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
for ($n=1;$n<=24;$n++) {
if ($n =~ /\d\d/) {$t = $n}else{$t = ("0$n")}
if ($max_time_clicks) {$timeline_click_per = ($timeline_click_list{$t} / $max_time_clicks) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$t</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$timeline_click_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$timeline_click_list{$t}</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Timeline by impressions</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
for ($n=1;$n<=24;$n++) {
if ($n =~ /\d\d/) {$t = $n}else{$t = ("0$n")}
if ($max_time_imps) {$timeline_imp_per = ($timeline_imp_list{$t} / $max_time_imps) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$t</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$timeline_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$timeline_imp_list{$t}</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
EOF

#-------------------------------------------------------------------#
}elsif ($input{'action'} eq 'catreport') {
#-------------------------------------------------------------------#
open(HEADERFILE, "$input{'log'}") || die("error opening the file $input{'log'}");
	@log_lines = <HEADERFILE>;
close(HEADERFILE);

foreach $line (@log_lines) {
	($mark,$banner,$cat,$timestamp) = split(/\|\|/,$line);
	chomp($timestamp);
	if ($banner) {
		push(@marks, $mark);
		push(@banners, $banner);
		push(@cats, $cat);
		push(@timestamps, $timestamp);
		($hour,$min) = split(/\:/,$timestamp);

		if ($mark eq 'C') {
			if ($cat eq $input{'cat'}) {
				$banners_click_list{$banner} = $banners_click_list{$banner} + 1;
				$category_click_list{$cat} = $category_click_list{$cat} + 1;
				$timeline_click_list{$hour}++;
			}
		}else{
			if ($cat eq $input{'cat'}) {
				$banners_imp_list{$banner} = $banners_imp_list{$banner} + 1;
				$category_imp_list{$cat} = $category_imp_list{$cat} + 1;
				$timeline_imp_list{$hour}++;
			}
		}
	}
}

for ($n=0;$n<=$#marks;$n++) {
	if ($marks[$n] eq 'C') {
		$total_clicks++;
	}else{
		$total_impressions++;
	}
}

if ($total_clicks >= $total_impressions) {
	$total_total = $total_clicks;
}else{
	$total_total = $total_impressions;
}

if ($total_clicks) {
	$total_clicks_per = ($total_clicks / $total_total) * 100;
}else{
	$total_clicks_per = 0;
}
if ($total_impressions) {
	$total_imp_per = ($total_impressions / $total_total) * 100;
}else{
	$total_imp_per = 0;
}

while (($key,$value) = each(%banners_click_list)) {
	if ($value > $max_banner_clicks) {$max_banner_clicks = $value;}
}

while (($key,$value) = each(%banners_imp_list)) {
	if ($value > $max_banner_imps) {$max_banner_imps = $value;}
}

while (($key,$value) = each(%category_click_list)) {
	if ($value > $max_cat_clicks) {$max_cat_clicks = $value;}
}

while (($key,$value) = each(%category_imp_list)) {
	if ($value > $max_cat_imps) {$max_cat_imps = $value;}
}

while (($key,$value) = each(%timeline_click_list)) {
	if ($value > $max_time_clicks) {$max_time_clicks = $value;}
}

while (($key,$value) = each(%timeline_imp_list)) {
	if ($value > $max_time_imps) {$max_time_imps = $value;}
}

print "Content-type: text/html\n\n";
print <<EOF;
<html>
<BODY BGCOLOR="#FFFFFF">
<FONT SIZE="7" COLOR="#000099" face="Arial,Helvetica">Category Report</FONT>
<br>
<FONT SIZE="4" COLOR="#000099" face="Arial,Helvetica">$input{'cat'} on log $input{'log'}</FONT>
<HR size=1><p>
<H3>Clicks by banner</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%banners_click_list)) {
if ($max_banner_clicks) {$banner_click_per = ($value / $max_banner_clicks) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$title_list{$key}</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$banner_click_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Impressions by banner</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%banners_imp_list)) {
if ($max_banner_imps) {$banner_imp_per = ($value / $max_banner_imps) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$title_list{$key}</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$banner_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Clicks by category</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%category_click_list)) {
if ($max_cat_clicks) {$category_cat_per = ($value / $max_cat_clicks) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$key</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$category_cat_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Impressions by category</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%category_imp_list)) {
if ($max_cat_imps) {$category_imp_per = ($value / $max_cat_imps) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$key</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$category_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Timeline by clicks</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
for ($n=1;$n<=24;$n++) {
if ($n =~ /\d\d/) {$t = $n}else{$t = ("0$n")}
if ($max_time_clicks) {$timeline_click_per = ($timeline_click_list{$t} / $max_time_clicks) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$t</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$timeline_click_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$timeline_click_list{$t}</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Timeline by impressions</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
for ($n=1;$n<=24;$n++) {
if ($n =~ /\d\d/) {$t = $n}else{$t = ("0$n")}
if ($max_time_imps) {$timeline_imp_per = ($timeline_imp_list{$t} / $max_time_imps) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$t</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$timeline_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$timeline_imp_list{$t}</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
EOF

#-------------------------------------------------------------------#
} elsif ($input{'action'} eq 'fullreport') {
#-------------------------------------------------------------------#
open(HEADERFILE, "$input{'log'}") || die("error opening the file $input{'log'}");
	@log_lines = <HEADERFILE>;
close(HEADERFILE);

foreach $line (@log_lines) {
	($mark,$banner,$cat,$timestamp) = split(/\|\|/,$line);
	chomp($timestamp);
	if ($banner) {
		push(@marks, $mark);
		push(@banners, $banner);
		push(@cats, $cat);
		push(@timestamps, $timestamp);
		($hour,$min) = split(/\:/,$timestamp);

		if ($mark eq 'C') {
				$banners_click_list{$banner} = $banners_click_list{$banner} + 1;
				$category_click_list{$cat} = $category_click_list{$cat} + 1;
				$timeline_click_list{$hour}++;
		}else{
				$banners_imp_list{$banner} = $banners_imp_list{$banner} + 1;
				$category_imp_list{$cat} = $category_imp_list{$cat} + 1;
				$timeline_imp_list{$hour}++;
		}
	}
}

for ($n=0;$n<=$#marks;$n++) {
	if ($marks[$n] eq 'C') {
		$total_clicks++;
	}else{
		$total_impressions++;
	}
}


if ($total_clicks >= $total_impressions) {
	$total_total = $total_clicks;
}else{
	$total_total = $total_impressions;
}
$total_clicks_per = ($total_clicks / $total_total) * 100;
$total_imp_per = ($total_impressions / $total_total) * 100;

while (($key,$value) = each(%banners_click_list)) {
	if ($value > $max_banner_clicks) {$max_banner_clicks = $value;}
}

while (($key,$value) = each(%banners_imp_list)) {
	if ($value > $max_banner_imps) {$max_banner_imps = $value;}
}

while (($key,$value) = each(%category_click_list)) {
	if ($value > $max_cat_clicks) {$max_cat_clicks = $value;}
}

while (($key,$value) = each(%category_imp_list)) {
	if ($value > $max_cat_imps) {$max_cat_imps = $value;}
}

while (($key,$value) = each(%timeline_click_list)) {
	if ($value > $max_time_clicks) {$max_time_clicks = $value;}
}

while (($key,$value) = each(%timeline_imp_list)) {
	if ($value > $max_time_imps) {$max_time_imps = $value;}
}

print "Content-type: text/html\n\n";
print <<EOF;
<html>
<BODY BGCOLOR="#FFFFFF">
<FONT SIZE="7" COLOR="#000099" face="Arial,Helvetica">Day Report</FONT>
<br>
<FONT SIZE="4" COLOR="#000099" face="Arial,Helvetica">On log $input{'log'}</FONT>
<HR size=1><p>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
<TR>
	<TD><FONT SIZE="2" face="Arial,Helvetica"><B>Total Clicks:</B></FONT></TD>
	<TD width="75%" bgcolor="#EEEEEE"><Table width="$total_clicks_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$total_clicks</FONT></td></tr></table></TD>
</TR>
<TR>
	<TD><FONT SIZE="2" face="Arial,Helvetica"><B>Total Impressions:</B></FONT></TD>
	<TD width="75%" bgcolor="#EEEEEE"><Table width="$total_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$total_impressions</FONT></td></tr></table></TD>
</TR>

</TABLE>

<H3>Clicks by banner</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%banners_click_list)) {
if ($max_banner_clicks) {$banner_click_per = ($value / $max_banner_clicks) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$title_list{$key}</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$banner_click_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Impressions by banner</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%banners_imp_list)) {
if ($max_banner_imps) {$banner_imp_per = ($value / $max_banner_imps) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$title_list{$key}</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$banner_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Clicks by category</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%category_click_list)) {
if ($max_cat_clicks) {$category_cat_per = ($value / $max_cat_clicks) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$key</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$category_cat_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Impressions by category</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
while (($key,$value) = each(%category_imp_list)) {
if ($max_cat_imps) {$category_imp_per = ($value / $max_cat_imps) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$key</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$category_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$value</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Timeline by clicks</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
for ($n=1;$n<=24;$n++) {
if ($n =~ /\d\d/) {$t = $n}else{$t = ("0$n")}
if ($max_time_clicks) {$timeline_click_per = ($timeline_click_list{$t} / $max_time_clicks) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$t</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$timeline_click_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$timeline_click_list{$t}</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
<H3>Timeline by impressions</H3>
<TABLE width="100%" cellpadding=0 cellspacing=2 border=0>
EOF
for ($n=1;$n<=24;$n++) {
if ($n =~ /\d\d/) {$t = $n}else{$t = ("0$n")}
if ($max_time_imps) {$timeline_imp_per = ($timeline_imp_list{$t} / $max_time_imps) * 100;}
print <<EOF;
	<TR>
		<TD><FONT SIZE="2" face="Arial,Helvetica"><B>$t</B></FONT></TD>
		<TD width="75%" bgcolor="#EEEEEE"><Table width="$timeline_imp_per%" bgcolor="#FFFF99" cellpadding=0 cellspacing=0 border=0><tr><td><FONT SIZE="2">$timeline_imp_list{$t}</FONT></td></tr></table></TD>
	</TR>
EOF
}
print <<EOF;
</TABLE>
EOF
#-------------------------------------------------------------------#
}else{
#-------------------------------------------------------------------#
opendir(LOGDIR, ".") || die("error");
	@file_list = readdir(LOGDIR);
closedir(LOGDIR);

foreach $file (@file_list) {
	($name,$exe) = split(/\./,$file);
	if ($exe eq 'log') {
		push(@log_filenames, $name);
		($month,$day,$year) = split(/\-/,$file);
		($year) = split(/\./,$year);
		$all_months{"$smonths{$month} $year"} = 'x';
	}
}

open(HEADERFILE, "categories.dat") || die("error opening the file categories.dat");
	@cat_lines = <HEADERFILE>;
close(HEADERFILE);

@all_categories = @cat_lines;

$totalcat = $#all_categories+1;
print "Content-type: text/html\n\n";
print <<EOF;
<html>
<BODY BGCOLOR="#FFFFFF">
<FONT SIZE="7" COLOR="#000099" face="Arial,Helvetica">Banner Statistics</FONT>
<br>
<FONT SIZE="1" COLOR="#000099" face="Arial,Helvetica"><A HREF="report2.cgi">Home</A> | <A HREF="bannereditor.cgi">Banner Manager</A></FONT>
<HR size=1><p>

<TABLE width="75%" cellpadding=0 cellspacing=2 border=0>
<TR>
	<TD><FONT SIZE="5" COLOR="#003399" face="Arial,Helvetica">Today</FONT></TD>
	<TD><FONT SIZE="5" COLOR="#003399" face="Arial,Helvetica">History</FONT></TD>
</TR>
<TR>
	<TD><FONT SIZE="2" COLOR="#003399" face="Arial,Helvetica">
		<A HREF="report2.cgi?action=fullreport&log=$logfile">Full Report</A><br>
		<p>($totalcat) By Category:<br><UL>
EOF
foreach $cat (@all_categories) {
			print "<LI><A HREF=\"report2.cgi?action=catreport&log=$logfile&cat=$cat\">$cat</A>";
}
$totaltitles = $#all_titles +1;
print <<EOF;
		</UL><p>
		($totaltitles) By Banner:<br>
		<UL>
EOF
foreach $title (@all_titles) {
		$tmp = $title;
		$tmp =~ s/ /\+/g;
		print "<LI><A HREF=\"report2.cgi?action=banreport&log=$logfile&title=$tmp\">$title</A>";
}
print <<EOF;
		</UL>
	</FONT></TD>
	<TD valign="top" ><FONT SIZE="3" COLOR="#003399" face="Arial,Helvetica">
EOF
foreach $month (keys(%all_months)) {
	print "<A HREF=\"report2.cgi?action=monthreport&month=$month\">$month</A><br>";
}
print <<EOF;
	</FONT></TD>
</TR>

</TABLE></CENTER>
EOF
}